import { StorageItem, StorageTarget } from '../definitions/interfaces.js';
import { KeyOf } from '../definitions/types.js';
type Clear = () => ClearReturn;
type ClearReturn = void | Error | Promise<void | Error>;
type CopyReturn = void | Error | Promise<void | Error>;
type Get = <T extends StorageItem>(key: string) => GetReturn<T>;
type GetReturn<T extends StorageItem> = T | Error | Promise<T | Error>;
type Has = (key: string) => HasReturn;
type HasReturn = boolean | Error | Promise<boolean | Error>;
type Remove = (key: string) => RemoveReturn;
type RemoveReturn = void | Error | Promise<void | Error>;
type Set = <T extends StorageItem>(key: string, item: T) => SetReturn;
type SetReturn = void | Error | Promise<void | Error>;
export declare class Storage {
    /**
     * The storage instance name.
     */
    readonly name: string;
    protected readonly _clear: Clear;
    protected readonly _get: Get;
    protected readonly _has: Has;
    protected readonly _remove: Remove;
    protected readonly _set: Set;
    constructor(name: string, clear: Clear, get: Get, has: Has, remove: Remove, set: Set);
    protected clear_(cleared: void | Error): void | Error;
    clear(): ClearReturn;
    protected get_<T extends StorageItem>(key: string, item: T | Error): T | Error;
    get<T extends StorageItem>(key: string): GetReturn<T>;
    protected remove_(key: string, removed: void | Error): void | Error;
    protected remove__<T extends StorageItem>(key: string, keys: KeyOf.Deep<T>[], item: T | Error): T | undefined;
    protected remove___<T extends StorageItem>(key: string, item: T, set: void | Error): void | Error;
    remove<T extends StorageItem>(key: string, keys?: KeyOf.Deep<T>[]): RemoveReturn;
    protected set_<T extends StorageItem>(key: string, item: T | Error, set: void | Error): void | Error;
    protected set__<T extends StorageItem>(item: T, keys: KeyOf.Deep<T>[], current: T | Error): T | Error;
    set<T extends StorageItem>(key: string, item: T, keys?: KeyOf.Deep<T>[]): SetReturn;
    protected copy_<T1 extends StorageItem, T2 extends StorageTarget, T extends T1 & T2>(key: string, target: T2, keys: KeyOf.Deep<T>[] | undefined, item: T1 | Error): void | Error;
    copy<T1 extends StorageItem, T2 extends StorageTarget, T extends T1 & T2>(key: string, target: T2, keys?: KeyOf.Deep<T>[]): CopyReturn;
    protected has_<T extends StorageItem>(keys: KeyOf.Deep<T>[] | undefined, item: T | Error): boolean;
    has<T extends StorageItem>(key: string, keys?: KeyOf.Deep<T>[]): HasReturn;
}
export {};
