/**
 * Returns the value of a key in `process.env`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function getProcessEnvKey(key: string): string | undefined;
/**
 * Checks if a key exists in `process.env`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function hasProcessEnvKey(key: string): boolean;
/**
 * Returns the value of `process.env.NODE_ENV`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function getNodeEnv(): string | undefined;
/**
 * Checks if `Blob` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isBlobDefined(): boolean;
/**
 * Checks if `Blob` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isBlobNotDefined(): boolean;
/**
 * Checks if `document` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isDocumentDefined(): boolean;
/**
 * Checks if `document` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isDocumentNotDefined(): boolean;
/**
 * Checks if `fetch` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isFetchDefined(): boolean;
/**
 * Checks if `fetch` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isFetchNotDefined(): boolean;
/**
 * Checks if `File` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isFileDefined(): boolean;
/**
 * Checks if `File` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isFileNotDefined(): boolean;
/**
 * Checks if `FormData` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isFormDataDefined(): boolean;
/**
 * Checks if `FormData` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isFormDataNotDefined(): boolean;
/**
 * Checks if the `process.env.JEST_WORKER_ID` variable is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isJestDefined(): boolean;
/**
 * Checks if the `process.env.JEST_WORKER_ID` variable is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isJestNotDefined(): boolean;
/**
 * Checks if the `process.env.NODE_ENV` variable is set to `development`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isNodeEnvDevelopment(): boolean;
/**
 * Checks if the `process.env.NODE_ENV` variable is not set to `development`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isNodeEnvNotDevelopment(): boolean;
/**
 * Checks if the `process.env.NODE_ENV` variable is set to `production`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isNodeEnvProduction(): boolean;
/**
 * Checks if the `process.env.NODE_ENV` variable is not set to `production`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isNodeEnvNotProduction(): boolean;
/**
 * Checks if the `process.env.NODE_ENV` variable is set to `test`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isNodeEnvTest(): boolean;
/**
 * Checks if the `process.env.NODE_ENV` variable is not set to `test`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isNodeEnvNotTest(): boolean;
/**
 * Checks if `process` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isProcessDefined(): boolean;
/**
 * Checks if `process` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isProcessNotDefined(): boolean;
/**
 * Checks if `TextDecoder` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isTextDecoderDefined(): boolean;
/**
 * Checks if `TextDecoder` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isTextDecoderNotDefined(): boolean;
/**
 * Checks if `TextEncoder` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isTextEncoderDefined(): boolean;
/**
 * Checks if `TextEncoder` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isTextEncoderNotDefined(): boolean;
/**
 * Checks if `window` is defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isWindowDefined(): boolean;
/**
 * Checks if `window` is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/environment)
 */
export declare function isWindowNotDefined(): boolean;
