import { DecodeBase64Options, DecodeBase64URLOptions, EncodeBase64Options, EncodeBase64URLOptions } from '../definitions/interfaces.js';
/**
 * Decodes a base64 string into a Uint8Array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/base64)
 */
export declare function decodeBase64(string: string, options?: DecodeBase64Options): Uint8Array;
/**
 * Decodes a base64url string into a Uint8Array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/base64)
 */
export declare function decodeBase64URL(string: string, options?: DecodeBase64URLOptions): Uint8Array;
/**
 * Encodes an array of integers into a base64 string.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/base64)
 */
export declare function encodeBase64(array: ArrayLike<number>, options?: EncodeBase64Options): string;
/**
 * Encodes an array of integers into a base64url string.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/base64)
 */
export declare function encodeBase64URL(array: ArrayLike<number>, options?: EncodeBase64URLOptions): string;
