import { JoinPathsOptions } from '../definitions/interfaces.js';
/**
 * Joins a sequence of paths together.
 * Optionally uses the Windows standard.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/path)
 */
export declare function joinPaths(paths: string[], options?: JoinPathsOptions): string;
export declare function joinPaths(...paths: string[]): string;
/**
 * Joins a sequence of paths together using the Windows standard.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/path)
 */
export declare function joinWindowsPaths(...paths: string[]): string;
