import { AracnaBlobJSON } from '../definitions/interfaces.js';
/**
 * The AracnaBlob class is built on top of the Blob class.
 *
 * - The data contained in the Blob can be resolved asynchronously and accessed at a later time from the instance itself.
 * - The instance supports JSON serialization and deserialization out of the box unlike the Blob class.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/aracna-blob)
 */
export declare class AracnaBlob {
    private _arrayBuffer?;
    /**
     * The Blob instance.
     */
    readonly blob: Blob;
    /**
     * The unique identifier of the instance.
     */
    readonly id: string;
    private _text?;
    constructor(blob: Blob);
    constructor(json: AracnaBlobJSON);
    /**
     * Resolves the data contained in the Blob as an ArrayBuffer.
     */
    resolveArrayBuffer(): Promise<void>;
    /**
     * Resolves the data contained in the Blob as a string.
     */
    resolveText(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/slice) */
    slice(start?: number, end?: number, contentType?: string): Blob;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/stream) */
    stream(): ReadableStream<Uint8Array>;
    stream(): NodeJS.ReadableStream;
    /**
     * Serializes the instance into a JSON object.
     */
    toJSON(): AracnaBlobJSON;
    /**
     * Returns the data contained in the Blob as an ArrayBuffer.
     * You need to call the "resolveArrayBuffer" method before accessing this property.
     */
    get arrayBuffer(): ArrayBuffer;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/size) */
    get size(): number;
    /**
     * Returns the data contained in the Blob as a string.
     * You need to call the "resolveText" method before accessing this property.
     */
    get text(): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/type) */
    get type(): string;
    /**
     * Returns the data contained in the Blob as a Uint8Array.
     * You need to call the "resolveArrayBuffer" or "resolveText" method before accessing this property.
     */
    get uInt8Array(): Uint8Array;
    /**
     * Returns an empty AracnaBlob instance.
     */
    static get EMPTY(): AracnaBlob;
}
