import { DebounceMapKey } from '../definitions/types.js';
/**
 * The `debounce` function is used to prevent a function from being called too many times in a short period.
 * The function will only be called after it stops being called for the specified amount of time.
 *
 * Optionally the key can be specified, otherwise the function itself will be used as the key.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/functions/debounce)
 */
export declare function debounce(fn: Function, ms: number, key?: DebounceMapKey): void;
