import { TimeoutMapKey } from '../definitions/types.js';
/**
 * Sets a timeout to run a function after `ms` milliseconds.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/timeout)
 */
declare function set(fn: Function, ms: number, key?: TimeoutMapKey): void;
/**
 * Clears a timeout.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/timeout)
 */
declare function clear(key: TimeoutMapKey): void;
/**
 * Clears all timeouts.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/timeout)
 */
export declare function clearEveryTimeout(): void;
/**
 * Checks if a timeout is set.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/timeout)
 */
export declare function isTimeoutSet(key: TimeoutMapKey): boolean;
/**
 * Checks if a timeout is not set.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/timeout)
 */
export declare function isTimeoutUnset(key: TimeoutMapKey): boolean;
export { clear as clearTimeout, set as setTimeout };
