import { AracnaBlob } from '../classes/aracna-blob.js';
import { DeserializeBlobOptions } from '../definitions/interfaces.js';
/**
 * Deserializes a `Blob` object into an `AracnaBlob` instance.
 * Optionally resolves the data of the blob.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/blob)
 */
export declare function deserializeBlob(blob: Blob, options?: DeserializeBlobOptions): Promise<AracnaBlob>;
/**
 * Serializes an `AracnaBlob` instance into a `Blob` object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/blob)
 */
export declare function serializeBlob(blob: AracnaBlob, endings?: EndingType): Blob;
