/**
 * Checks if an unknown value is an Error.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/error)
 */
export declare function isError(value: unknown): value is Error;
/**
 * Checks if a value is not an Error.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/error)
 */
export declare function isNotError<T>(value: T | Error): value is T;
