import { VisibilityControllerToggleDelay } from '../definitions/types.js';
/**
 * The VisibilityController class is used to control the visibility of anything that can be hidden or shown.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/visibility-controller)
 */
export declare class VisibilityController {
    protected readonly data: Map<string, string>;
    /**
     * Hides the entity with the given name.
     * Optionally a delay can be set.
     */
    hide(name: string, delay?: number): Promise<void>;
    /**
     * Shows the entity with the given name.
     * Optionally a delay can be set.
     */
    show(name: string, delay?: number): Promise<void>;
    /**
     * Toggles the entity with the given name.
     * Optionally a delay can be set, which can be different for hiding and showing.
     */
    toggle(name: string, delay?: VisibilityControllerToggleDelay): Promise<void>;
    /**
     * Clears the visibility of all entities.
     */
    clear(): void;
    protected get(name: string): string;
    /**
     * Checks if the entity with the given name is hidden.
     */
    isHidden(name: string): boolean;
    /**
     * Checks if the entity with the given name is hiding.
     */
    isHiding(name: string): boolean;
    /**
     * Checks if the entity with the given name is showing.
     */
    isShowing(name: string): boolean;
    /**
     * Checks if the entity with the given name is visible.
     */
    isVisible(name: string): boolean;
    /**
     * Checks if any entity is hidden.
     */
    get hasHidden(): boolean;
    /**
     * Checks if any entity is hiding.
     */
    get hasHiding(): boolean;
    /**
     * Checks if any entity is showing.
     */
    get hasShowing(): boolean;
    /**
     * Checks if any entity is visible.
     */
    get hasVisible(): boolean;
    protected static get HIDDEN(): string;
    protected static get HIDING(): string;
    protected static get SHOWING(): string;
    protected static get VISIBLE(): string;
}
