import { CookieParseOptions, CookieSerializeOptions } from 'cookie';
import { CookieObject } from '../definitions/interfaces.js';
/**
 * Deserializes a cookie string to an object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/cookie)
 */
export declare function deserializeCookie(cookie: string, options?: CookieParseOptions): CookieObject;
/**
 * Serializes a cookie name-value pair into a string suitable for use in a `Set-Cookie` header or `document.cookie` property.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/cookie)
 */
export declare function serializeCookie(key: string, value: string, options?: CookieSerializeOptions): string | Error;
