import { ECDH } from 'crypto';
/**
 * Creates a new ECDH instance with the prime256v1 curve and generates a new key pair.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/fcm/utils/crypto)
 */
export declare function createFcmECDH(): ECDH;
/**
 * Generates a new FCM auth secret.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/fcm/utils/crypto)
 */
export declare function generateFcmAuthSecret(): Uint8Array;
