import { FetchRequestInit } from '../definitions/interfaces.js';
import { FetchRequestInfo } from '../definitions/types.js';
import { FetchError } from './fetch-error.js';
import { FetchResponse } from './fetch-response.js';
/**
 * The Fetch class is built on top of the native Fetch API and it is isomorphic, which means that it can be used in both Node.js and browsers.
 *
 * - The body and headers of the request are automatically generated based on the body.
 * - The body of the response is dynamically parsed based on the Content-Type header, unless the parse option is set to false.
 * - Enabling logs will give you a detailed overview of the requests and responses.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/fetch)
 */
export declare class Fetch {
    /**
     * Sends a request.
     */
    static send<T, U, V>(input: FetchRequestInfo, init?: FetchRequestInit<V>): Promise<FetchResponse<T> | FetchError<U>>;
    /**
     * Sends a CONNECT request.
     */
    static connect<T, U>(input: FetchRequestInfo, init?: FetchRequestInit): Promise<FetchResponse<T> | FetchError<U>>;
    /**
     * Sends a DELETE request.
     */
    static delete<T, U, V>(input: FetchRequestInfo, body?: V, init?: FetchRequestInit): Promise<FetchResponse<T> | FetchError<U>>;
    /**
     * Sends a GET request.
     */
    static get<T, U>(input: FetchRequestInfo, init?: FetchRequestInit): Promise<FetchResponse<T> | FetchError<U>>;
    /**
     * Sends a HEAD request.
     */
    static head(input: FetchRequestInfo, init?: FetchRequestInit): Promise<FetchResponse | FetchError>;
    /**
     * Sends a OPTIONS request.
     */
    static options<T, U>(input: FetchRequestInfo, init?: FetchRequestInit): Promise<FetchResponse<T> | FetchError<U>>;
    /**
     * Sends a PATCH request.
     */
    static patch<T, U, V>(input: FetchRequestInfo, body?: V, init?: FetchRequestInit): Promise<FetchResponse<T> | FetchError<U>>;
    /**
     * Sends a POST request.
     */
    static post<T, U, V>(input: FetchRequestInfo, body?: V, init?: FetchRequestInit): Promise<FetchResponse<T> | FetchError<U>>;
    /**
     * Sends a PUT request.
     */
    static put<V>(input: FetchRequestInfo, body?: V, init?: FetchRequestInit): Promise<FetchResponse | FetchError>;
    /**
     * Sends a TRACE request.
     */
    static trace(input: FetchRequestInfo, init?: FetchRequestInit): Promise<FetchResponse | FetchError>;
}
