import { DecodeBase16Options, EncodeBase16Options } from '../definitions/interfaces.js';
/**
 * Decodes a base16 string into a Uint8Array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/base16)
 */
export declare function decodeBase16(string: string, options?: DecodeBase16Options): Uint8Array;
/**
 * Encodes an array of integers into a base16 string.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/base16)
 */
export declare function encodeBase16(array: ArrayLike<number>, options?: EncodeBase16Options): string;
