Object.defineProperty(exports, '__esModule', { value: true });

const errors = require('./tracing/errors.js');
const utils = require('./tracing/utils.js');
const hubextensions = require('./tracing/hubextensions.js');
const idleSpan = require('./tracing/idleSpan.js');
const sentrySpan = require('./tracing/sentrySpan.js');
const sentryNonRecordingSpan = require('./tracing/sentryNonRecordingSpan.js');
const spanstatus = require('./tracing/spanstatus.js');
const trace = require('./tracing/trace.js');
const dynamicSamplingContext = require('./tracing/dynamicSamplingContext.js');
const measurement = require('./tracing/measurement.js');
const sampling = require('./tracing/sampling.js');
const logSpans = require('./tracing/logSpans.js');
const semanticAttributes = require('./semanticAttributes.js');
const envelope = require('./envelope.js');
const exports$1 = require('./exports.js');
const currentScopes = require('./currentScopes.js');
const defaultScopes = require('./defaultScopes.js');
const index = require('./asyncContext/index.js');
const carrier = require('./carrier.js');
const session = require('./session.js');
const sessionflusher = require('./sessionflusher.js');
const scope = require('./scope.js');
const eventProcessors = require('./eventProcessors.js');
const api = require('./api.js');
const baseclient = require('./baseclient.js');
const serverRuntimeClient = require('./server-runtime-client.js');
const sdk = require('./sdk.js');
const base = require('./transports/base.js');
const offline = require('./transports/offline.js');
const multiplexed = require('./transports/multiplexed.js');
const integration = require('./integration.js');
const applyScopeDataToEvent = require('./utils/applyScopeDataToEvent.js');
const prepareEvent = require('./utils/prepareEvent.js');
const checkin = require('./checkin.js');
const hasTracingEnabled = require('./utils/hasTracingEnabled.js');
const isSentryRequestUrl = require('./utils/isSentryRequestUrl.js');
const handleCallbackErrors = require('./utils/handleCallbackErrors.js');
const parameterize = require('./utils/parameterize.js');
const spanUtils = require('./utils/spanUtils.js');
const parseSampleRate = require('./utils/parseSampleRate.js');
const sdkMetadata = require('./utils/sdkMetadata.js');
const traceData = require('./utils/traceData.js');
const meta = require('./utils/meta.js');
const constants = require('./constants.js');
const breadcrumbs = require('./breadcrumbs.js');
const functiontostring = require('./integrations/functiontostring.js');
const inboundfilters = require('./integrations/inboundfilters.js');
const linkederrors = require('./integrations/linkederrors.js');
const metadata = require('./integrations/metadata.js');
const requestdata = require('./integrations/requestdata.js');
const captureconsole = require('./integrations/captureconsole.js');
const debug = require('./integrations/debug.js');
const dedupe = require('./integrations/dedupe.js');
const extraerrordata = require('./integrations/extraerrordata.js');
const rewriteframes = require('./integrations/rewriteframes.js');
const sessiontiming = require('./integrations/sessiontiming.js');
const zoderrors = require('./integrations/zoderrors.js');
const thirdPartyErrorsFilter = require('./integrations/third-party-errors-filter.js');
const exports$2 = require('./metrics/exports.js');
const profiling = require('./profiling.js');
const exportsDefault = require('./metrics/exports-default.js');
const browserAggregator = require('./metrics/browser-aggregator.js');
const metricSummary = require('./metrics/metric-summary.js');
const fetch = require('./fetch.js');
const trpc = require('./trpc.js');
const feedback = require('./feedback.js');
const getCurrentHubShim = require('./getCurrentHubShim.js');
const aggregateErrors = require('./utils-hoist/aggregate-errors.js');
const array = require('./utils-hoist/array.js');
const breadcrumbLogLevel = require('./utils-hoist/breadcrumb-log-level.js');
const browser = require('./utils-hoist/browser.js');
const dsn = require('./utils-hoist/dsn.js');
const error = require('./utils-hoist/error.js');
const worldwide = require('./utils-hoist/worldwide.js');
const console = require('./utils-hoist/instrument/console.js');
const fetch$1 = require('./utils-hoist/instrument/fetch.js');
const globalError = require('./utils-hoist/instrument/globalError.js');
const globalUnhandledRejection = require('./utils-hoist/instrument/globalUnhandledRejection.js');
const handlers = require('./utils-hoist/instrument/handlers.js');
const is = require('./utils-hoist/is.js');
const isBrowser = require('./utils-hoist/isBrowser.js');
const logger = require('./utils-hoist/logger.js');
const memo = require('./utils-hoist/memo.js');
const misc = require('./utils-hoist/misc.js');
const node = require('./utils-hoist/node.js');
const normalize = require('./utils-hoist/normalize.js');
const object = require('./utils-hoist/object.js');
const path = require('./utils-hoist/path.js');
const promisebuffer = require('./utils-hoist/promisebuffer.js');
const requestdata$1 = require('./utils-hoist/requestdata.js');
const severity = require('./utils-hoist/severity.js');
const stacktrace = require('./utils-hoist/stacktrace.js');
const nodeStackTrace = require('./utils-hoist/node-stack-trace.js');
const string = require('./utils-hoist/string.js');
const supports = require('./utils-hoist/supports.js');
const syncpromise = require('./utils-hoist/syncpromise.js');
const time = require('./utils-hoist/time.js');
const tracing = require('./utils-hoist/tracing.js');
const env = require('./utils-hoist/env.js');
const envelope$1 = require('./utils-hoist/envelope.js');
const clientreport = require('./utils-hoist/clientreport.js');
const ratelimit = require('./utils-hoist/ratelimit.js');
const baggage = require('./utils-hoist/baggage.js');
const url = require('./utils-hoist/url.js');
const cache = require('./utils-hoist/cache.js');
const eventbuilder = require('./utils-hoist/eventbuilder.js');
const anr = require('./utils-hoist/anr.js');
const lru = require('./utils-hoist/lru.js');
const propagationContext = require('./utils-hoist/propagationContext.js');
const vercelWaitUntil = require('./utils-hoist/vercelWaitUntil.js');
const version = require('./utils-hoist/version.js');
const debugIds = require('./utils-hoist/debug-ids.js');
const escapeStringForRegex = require('./utils-hoist/vendor/escapeStringForRegex.js');
const supportsHistory = require('./utils-hoist/vendor/supportsHistory.js');
const _asyncNullishCoalesce = require('./utils-hoist/buildPolyfills/_asyncNullishCoalesce.js');
const _asyncOptionalChain = require('./utils-hoist/buildPolyfills/_asyncOptionalChain.js');
const _asyncOptionalChainDelete = require('./utils-hoist/buildPolyfills/_asyncOptionalChainDelete.js');
const _nullishCoalesce = require('./utils-hoist/buildPolyfills/_nullishCoalesce.js');
const _optionalChain = require('./utils-hoist/buildPolyfills/_optionalChain.js');
const _optionalChainDelete = require('./utils-hoist/buildPolyfills/_optionalChainDelete.js');



exports.registerSpanErrorInstrumentation = errors.registerSpanErrorInstrumentation;
exports.getCapturedScopesOnSpan = utils.getCapturedScopesOnSpan;
exports.setCapturedScopesOnSpan = utils.setCapturedScopesOnSpan;
exports.addTracingExtensions = hubextensions.addTracingExtensions;
exports.TRACING_DEFAULTS = idleSpan.TRACING_DEFAULTS;
exports.startIdleSpan = idleSpan.startIdleSpan;
exports.SentrySpan = sentrySpan.SentrySpan;
exports.SentryNonRecordingSpan = sentryNonRecordingSpan.SentryNonRecordingSpan;
exports.SPAN_STATUS_ERROR = spanstatus.SPAN_STATUS_ERROR;
exports.SPAN_STATUS_OK = spanstatus.SPAN_STATUS_OK;
exports.SPAN_STATUS_UNSET = spanstatus.SPAN_STATUS_UNSET;
exports.getSpanStatusFromHttpCode = spanstatus.getSpanStatusFromHttpCode;
exports.setHttpStatus = spanstatus.setHttpStatus;
exports.continueTrace = trace.continueTrace;
exports.startInactiveSpan = trace.startInactiveSpan;
exports.startNewTrace = trace.startNewTrace;
exports.startSpan = trace.startSpan;
exports.startSpanManual = trace.startSpanManual;
exports.suppressTracing = trace.suppressTracing;
exports.withActiveSpan = trace.withActiveSpan;
exports.getDynamicSamplingContextFromClient = dynamicSamplingContext.getDynamicSamplingContextFromClient;
exports.getDynamicSamplingContextFromScope = dynamicSamplingContext.getDynamicSamplingContextFromScope;
exports.getDynamicSamplingContextFromSpan = dynamicSamplingContext.getDynamicSamplingContextFromSpan;
exports.spanToBaggageHeader = dynamicSamplingContext.spanToBaggageHeader;
exports.setMeasurement = measurement.setMeasurement;
exports.timedEventsToMeasurements = measurement.timedEventsToMeasurements;
exports.sampleSpan = sampling.sampleSpan;
exports.logSpanEnd = logSpans.logSpanEnd;
exports.logSpanStart = logSpans.logSpanStart;
exports.SEMANTIC_ATTRIBUTE_CACHE_HIT = semanticAttributes.SEMANTIC_ATTRIBUTE_CACHE_HIT;
exports.SEMANTIC_ATTRIBUTE_CACHE_ITEM_SIZE = semanticAttributes.SEMANTIC_ATTRIBUTE_CACHE_ITEM_SIZE;
exports.SEMANTIC_ATTRIBUTE_CACHE_KEY = semanticAttributes.SEMANTIC_ATTRIBUTE_CACHE_KEY;
exports.SEMANTIC_ATTRIBUTE_EXCLUSIVE_TIME = semanticAttributes.SEMANTIC_ATTRIBUTE_EXCLUSIVE_TIME;
exports.SEMANTIC_ATTRIBUTE_HTTP_REQUEST_METHOD = semanticAttributes.SEMANTIC_ATTRIBUTE_HTTP_REQUEST_METHOD;
exports.SEMANTIC_ATTRIBUTE_PROFILE_ID = semanticAttributes.SEMANTIC_ATTRIBUTE_PROFILE_ID;
exports.SEMANTIC_ATTRIBUTE_SENTRY_CUSTOM_SPAN_NAME = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_CUSTOM_SPAN_NAME;
exports.SEMANTIC_ATTRIBUTE_SENTRY_IDLE_SPAN_FINISH_REASON = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_IDLE_SPAN_FINISH_REASON;
exports.SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_UNIT = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_UNIT;
exports.SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_VALUE = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_VALUE;
exports.SEMANTIC_ATTRIBUTE_SENTRY_OP = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_OP;
exports.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE;
exports.SEMANTIC_ATTRIBUTE_URL_FULL = semanticAttributes.SEMANTIC_ATTRIBUTE_URL_FULL;
exports.createEventEnvelope = envelope.createEventEnvelope;
exports.createSessionEnvelope = envelope.createSessionEnvelope;
exports.createSpanEnvelope = envelope.createSpanEnvelope;
exports.addEventProcessor = exports$1.addEventProcessor;
exports.captureCheckIn = exports$1.captureCheckIn;
exports.captureEvent = exports$1.captureEvent;
exports.captureException = exports$1.captureException;
exports.captureMessage = exports$1.captureMessage;
exports.captureSession = exports$1.captureSession;
exports.close = exports$1.close;
exports.endSession = exports$1.endSession;
exports.flush = exports$1.flush;
exports.isEnabled = exports$1.isEnabled;
exports.isInitialized = exports$1.isInitialized;
exports.lastEventId = exports$1.lastEventId;
exports.setContext = exports$1.setContext;
exports.setExtra = exports$1.setExtra;
exports.setExtras = exports$1.setExtras;
exports.setTag = exports$1.setTag;
exports.setTags = exports$1.setTags;
exports.setUser = exports$1.setUser;
exports.startSession = exports$1.startSession;
exports.withMonitor = exports$1.withMonitor;
exports.getClient = currentScopes.getClient;
exports.getCurrentScope = currentScopes.getCurrentScope;
exports.getGlobalScope = currentScopes.getGlobalScope;
exports.getIsolationScope = currentScopes.getIsolationScope;
exports.getTraceContextFromScope = currentScopes.getTraceContextFromScope;
exports.withIsolationScope = currentScopes.withIsolationScope;
exports.withScope = currentScopes.withScope;
exports.getDefaultCurrentScope = defaultScopes.getDefaultCurrentScope;
exports.getDefaultIsolationScope = defaultScopes.getDefaultIsolationScope;
exports.setAsyncContextStrategy = index.setAsyncContextStrategy;
exports.getMainCarrier = carrier.getMainCarrier;
exports.closeSession = session.closeSession;
exports.makeSession = session.makeSession;
exports.updateSession = session.updateSession;
exports.SessionFlusher = sessionflusher.SessionFlusher;
exports.Scope = scope.Scope;
exports.notifyEventProcessors = eventProcessors.notifyEventProcessors;
exports.getEnvelopeEndpointWithUrlEncodedAuth = api.getEnvelopeEndpointWithUrlEncodedAuth;
exports.getReportDialogEndpoint = api.getReportDialogEndpoint;
exports.BaseClient = baseclient.BaseClient;
exports.ServerRuntimeClient = serverRuntimeClient.ServerRuntimeClient;
exports.initAndBind = sdk.initAndBind;
exports.setCurrentClient = sdk.setCurrentClient;
exports.createTransport = base.createTransport;
exports.makeOfflineTransport = offline.makeOfflineTransport;
exports.makeMultiplexedTransport = multiplexed.makeMultiplexedTransport;
exports.addIntegration = integration.addIntegration;
exports.defineIntegration = integration.defineIntegration;
exports.getIntegrationsToSetup = integration.getIntegrationsToSetup;
exports.applyScopeDataToEvent = applyScopeDataToEvent.applyScopeDataToEvent;
exports.mergeScopeData = applyScopeDataToEvent.mergeScopeData;
exports.prepareEvent = prepareEvent.prepareEvent;
exports.createCheckInEnvelope = checkin.createCheckInEnvelope;
exports.hasTracingEnabled = hasTracingEnabled.hasTracingEnabled;
exports.isSentryRequestUrl = isSentryRequestUrl.isSentryRequestUrl;
exports.handleCallbackErrors = handleCallbackErrors.handleCallbackErrors;
exports.parameterize = parameterize.parameterize;
exports.addChildSpanToSpan = spanUtils.addChildSpanToSpan;
exports.getActiveSpan = spanUtils.getActiveSpan;
exports.getRootSpan = spanUtils.getRootSpan;
exports.getSpanDescendants = spanUtils.getSpanDescendants;
exports.getStatusMessage = spanUtils.getStatusMessage;
exports.spanIsSampled = spanUtils.spanIsSampled;
exports.spanTimeInputToSeconds = spanUtils.spanTimeInputToSeconds;
exports.spanToJSON = spanUtils.spanToJSON;
exports.spanToTraceContext = spanUtils.spanToTraceContext;
exports.spanToTraceHeader = spanUtils.spanToTraceHeader;
exports.updateSpanName = spanUtils.updateSpanName;
exports.parseSampleRate = parseSampleRate.parseSampleRate;
exports.applySdkMetadata = sdkMetadata.applySdkMetadata;
exports.getTraceData = traceData.getTraceData;
exports.getTraceMetaTags = meta.getTraceMetaTags;
exports.DEFAULT_ENVIRONMENT = constants.DEFAULT_ENVIRONMENT;
exports.addBreadcrumb = breadcrumbs.addBreadcrumb;
exports.functionToStringIntegration = functiontostring.functionToStringIntegration;
exports.inboundFiltersIntegration = inboundfilters.inboundFiltersIntegration;
exports.linkedErrorsIntegration = linkederrors.linkedErrorsIntegration;
exports.moduleMetadataIntegration = metadata.moduleMetadataIntegration;
exports.requestDataIntegration = requestdata.requestDataIntegration;
exports.captureConsoleIntegration = captureconsole.captureConsoleIntegration;
exports.debugIntegration = debug.debugIntegration;
exports.dedupeIntegration = dedupe.dedupeIntegration;
exports.extraErrorDataIntegration = extraerrordata.extraErrorDataIntegration;
exports.rewriteFramesIntegration = rewriteframes.rewriteFramesIntegration;
exports.sessionTimingIntegration = sessiontiming.sessionTimingIntegration;
exports.zodErrorsIntegration = zoderrors.zodErrorsIntegration;
exports.thirdPartyErrorFilterIntegration = thirdPartyErrorsFilter.thirdPartyErrorFilterIntegration;
exports.metrics = exports$2.metrics;
exports.profiler = profiling.profiler;
exports.metricsDefault = exportsDefault.metricsDefault;
exports.BrowserMetricsAggregator = browserAggregator.BrowserMetricsAggregator;
exports.getMetricSummaryJsonForSpan = metricSummary.getMetricSummaryJsonForSpan;
exports.addTracingHeadersToFetchRequest = fetch.addTracingHeadersToFetchRequest;
exports.instrumentFetchRequest = fetch.instrumentFetchRequest;
exports.trpcMiddleware = trpc.trpcMiddleware;
exports.captureFeedback = feedback.captureFeedback;
exports.getCurrentHub = getCurrentHubShim.getCurrentHub;
exports.getCurrentHubShim = getCurrentHubShim.getCurrentHubShim;
exports.applyAggregateErrorsToEvent = aggregateErrors.applyAggregateErrorsToEvent;
exports.flatten = array.flatten;
exports.getBreadcrumbLogLevelFromHttpStatusCode = breadcrumbLogLevel.getBreadcrumbLogLevelFromHttpStatusCode;
exports.getComponentName = browser.getComponentName;
exports.getDomElement = browser.getDomElement;
exports.getLocationHref = browser.getLocationHref;
exports.htmlTreeAsString = browser.htmlTreeAsString;
exports.dsnFromString = dsn.dsnFromString;
exports.dsnToString = dsn.dsnToString;
exports.makeDsn = dsn.makeDsn;
exports.SentryError = error.SentryError;
exports.GLOBAL_OBJ = worldwide.GLOBAL_OBJ;
exports.getGlobalSingleton = worldwide.getGlobalSingleton;
exports.addConsoleInstrumentationHandler = console.addConsoleInstrumentationHandler;
exports.addFetchEndInstrumentationHandler = fetch$1.addFetchEndInstrumentationHandler;
exports.addFetchInstrumentationHandler = fetch$1.addFetchInstrumentationHandler;
exports.addGlobalErrorInstrumentationHandler = globalError.addGlobalErrorInstrumentationHandler;
exports.addGlobalUnhandledRejectionInstrumentationHandler = globalUnhandledRejection.addGlobalUnhandledRejectionInstrumentationHandler;
exports.addHandler = handlers.addHandler;
exports.maybeInstrument = handlers.maybeInstrument;
exports.resetInstrumentationHandlers = handlers.resetInstrumentationHandlers;
exports.triggerHandlers = handlers.triggerHandlers;
exports.isDOMError = is.isDOMError;
exports.isDOMException = is.isDOMException;
exports.isElement = is.isElement;
exports.isError = is.isError;
exports.isErrorEvent = is.isErrorEvent;
exports.isEvent = is.isEvent;
exports.isInstanceOf = is.isInstanceOf;
exports.isParameterizedString = is.isParameterizedString;
exports.isPlainObject = is.isPlainObject;
exports.isPrimitive = is.isPrimitive;
exports.isRegExp = is.isRegExp;
exports.isString = is.isString;
exports.isSyntheticEvent = is.isSyntheticEvent;
exports.isThenable = is.isThenable;
exports.isVueViewModel = is.isVueViewModel;
exports.isBrowser = isBrowser.isBrowser;
exports.CONSOLE_LEVELS = logger.CONSOLE_LEVELS;
exports.consoleSandbox = logger.consoleSandbox;
exports.logger = logger.logger;
exports.originalConsoleMethods = logger.originalConsoleMethods;
exports.memoBuilder = memo.memoBuilder;
exports.addContextToFrame = misc.addContextToFrame;
exports.addExceptionMechanism = misc.addExceptionMechanism;
exports.addExceptionTypeValue = misc.addExceptionTypeValue;
exports.arrayify = misc.arrayify;
exports.checkOrSetAlreadyCaught = misc.checkOrSetAlreadyCaught;
exports.getEventDescription = misc.getEventDescription;
exports.parseSemver = misc.parseSemver;
exports.uuid4 = misc.uuid4;
exports.dynamicRequire = node.dynamicRequire;
exports.isNodeEnv = node.isNodeEnv;
exports.loadModule = node.loadModule;
exports.normalize = normalize.normalize;
exports.normalizeToSize = normalize.normalizeToSize;
exports.normalizeUrlToBase = normalize.normalizeUrlToBase;
exports.addNonEnumerableProperty = object.addNonEnumerableProperty;
exports.convertToPlainObject = object.convertToPlainObject;
exports.dropUndefinedKeys = object.dropUndefinedKeys;
exports.extractExceptionKeysForMessage = object.extractExceptionKeysForMessage;
exports.fill = object.fill;
exports.getOriginalFunction = object.getOriginalFunction;
exports.markFunctionWrapped = object.markFunctionWrapped;
exports.objectify = object.objectify;
exports.urlEncode = object.urlEncode;
exports.basename = path.basename;
exports.dirname = path.dirname;
exports.isAbsolute = path.isAbsolute;
exports.join = path.join;
exports.normalizePath = path.normalizePath;
exports.relative = path.relative;
exports.resolve = path.resolve;
exports.makePromiseBuffer = promisebuffer.makePromiseBuffer;
exports.DEFAULT_USER_INCLUDES = requestdata$1.DEFAULT_USER_INCLUDES;
exports.addNormalizedRequestDataToEvent = requestdata$1.addNormalizedRequestDataToEvent;
exports.addRequestDataToEvent = requestdata$1.addRequestDataToEvent;
exports.extractPathForTransaction = requestdata$1.extractPathForTransaction;
exports.extractQueryParamsFromUrl = requestdata$1.extractQueryParamsFromUrl;
exports.extractRequestData = requestdata$1.extractRequestData;
exports.headersToDict = requestdata$1.headersToDict;
exports.httpRequestToRequestData = requestdata$1.httpRequestToRequestData;
exports.winterCGHeadersToDict = requestdata$1.winterCGHeadersToDict;
exports.winterCGRequestToRequestData = requestdata$1.winterCGRequestToRequestData;
exports.severityLevelFromString = severity.severityLevelFromString;
exports.validSeverityLevels = severity.validSeverityLevels;
exports.UNKNOWN_FUNCTION = stacktrace.UNKNOWN_FUNCTION;
exports.createStackParser = stacktrace.createStackParser;
exports.getFramesFromEvent = stacktrace.getFramesFromEvent;
exports.getFunctionName = stacktrace.getFunctionName;
exports.stackParserFromStackParserOptions = stacktrace.stackParserFromStackParserOptions;
exports.stripSentryFramesAndReverse = stacktrace.stripSentryFramesAndReverse;
exports.filenameIsInApp = nodeStackTrace.filenameIsInApp;
exports.node = nodeStackTrace.node;
exports.nodeStackLineParser = nodeStackTrace.nodeStackLineParser;
exports.isMatchingPattern = string.isMatchingPattern;
exports.safeJoin = string.safeJoin;
exports.snipLine = string.snipLine;
exports.stringMatchesSomePattern = string.stringMatchesSomePattern;
exports.truncate = string.truncate;
exports.isNativeFunction = supports.isNativeFunction;
exports.supportsDOMError = supports.supportsDOMError;
exports.supportsDOMException = supports.supportsDOMException;
exports.supportsErrorEvent = supports.supportsErrorEvent;
exports.supportsFetch = supports.supportsFetch;
exports.supportsNativeFetch = supports.supportsNativeFetch;
exports.supportsReferrerPolicy = supports.supportsReferrerPolicy;
exports.supportsReportingObserver = supports.supportsReportingObserver;
exports.SyncPromise = syncpromise.SyncPromise;
exports.rejectedSyncPromise = syncpromise.rejectedSyncPromise;
exports.resolvedSyncPromise = syncpromise.resolvedSyncPromise;
Object.defineProperty(exports, "_browserPerformanceTimeOriginMode", {
  enumerable: true,
  get: () => time._browserPerformanceTimeOriginMode
});
exports.browserPerformanceTimeOrigin = time.browserPerformanceTimeOrigin;
exports.dateTimestampInSeconds = time.dateTimestampInSeconds;
exports.timestampInSeconds = time.timestampInSeconds;
exports.TRACEPARENT_REGEXP = tracing.TRACEPARENT_REGEXP;
exports.extractTraceparentData = tracing.extractTraceparentData;
exports.generateSentryTraceHeader = tracing.generateSentryTraceHeader;
exports.propagationContextFromHeaders = tracing.propagationContextFromHeaders;
exports.getSDKSource = env.getSDKSource;
exports.isBrowserBundle = env.isBrowserBundle;
exports.addItemToEnvelope = envelope$1.addItemToEnvelope;
exports.createAttachmentEnvelopeItem = envelope$1.createAttachmentEnvelopeItem;
exports.createEnvelope = envelope$1.createEnvelope;
exports.createEventEnvelopeHeaders = envelope$1.createEventEnvelopeHeaders;
exports.createSpanEnvelopeItem = envelope$1.createSpanEnvelopeItem;
exports.envelopeContainsItemType = envelope$1.envelopeContainsItemType;
exports.envelopeItemTypeToDataCategory = envelope$1.envelopeItemTypeToDataCategory;
exports.forEachEnvelopeItem = envelope$1.forEachEnvelopeItem;
exports.getSdkMetadataForEnvelopeHeader = envelope$1.getSdkMetadataForEnvelopeHeader;
exports.parseEnvelope = envelope$1.parseEnvelope;
exports.serializeEnvelope = envelope$1.serializeEnvelope;
exports.createClientReportEnvelope = clientreport.createClientReportEnvelope;
exports.DEFAULT_RETRY_AFTER = ratelimit.DEFAULT_RETRY_AFTER;
exports.disabledUntil = ratelimit.disabledUntil;
exports.isRateLimited = ratelimit.isRateLimited;
exports.parseRetryAfterHeader = ratelimit.parseRetryAfterHeader;
exports.updateRateLimits = ratelimit.updateRateLimits;
exports.BAGGAGE_HEADER_NAME = baggage.BAGGAGE_HEADER_NAME;
exports.MAX_BAGGAGE_STRING_LENGTH = baggage.MAX_BAGGAGE_STRING_LENGTH;
exports.SENTRY_BAGGAGE_KEY_PREFIX = baggage.SENTRY_BAGGAGE_KEY_PREFIX;
exports.SENTRY_BAGGAGE_KEY_PREFIX_REGEX = baggage.SENTRY_BAGGAGE_KEY_PREFIX_REGEX;
exports.baggageHeaderToDynamicSamplingContext = baggage.baggageHeaderToDynamicSamplingContext;
exports.dynamicSamplingContextToSentryBaggageHeader = baggage.dynamicSamplingContextToSentryBaggageHeader;
exports.parseBaggageHeader = baggage.parseBaggageHeader;
exports.getNumberOfUrlSegments = url.getNumberOfUrlSegments;
exports.getSanitizedUrlString = url.getSanitizedUrlString;
exports.parseUrl = url.parseUrl;
exports.stripUrlQueryAndFragment = url.stripUrlQueryAndFragment;
exports.makeFifoCache = cache.makeFifoCache;
exports.eventFromMessage = eventbuilder.eventFromMessage;
exports.eventFromUnknownInput = eventbuilder.eventFromUnknownInput;
exports.exceptionFromError = eventbuilder.exceptionFromError;
exports.parseStackFrames = eventbuilder.parseStackFrames;
exports.callFrameToStackFrame = anr.callFrameToStackFrame;
exports.watchdogTimer = anr.watchdogTimer;
exports.LRUMap = lru.LRUMap;
exports.generatePropagationContext = propagationContext.generatePropagationContext;
exports.generateSpanId = propagationContext.generateSpanId;
exports.generateTraceId = propagationContext.generateTraceId;
exports.vercelWaitUntil = vercelWaitUntil.vercelWaitUntil;
exports.SDK_VERSION = version.SDK_VERSION;
exports.getDebugImagesForResources = debugIds.getDebugImagesForResources;
exports.getFilenameToDebugIdMap = debugIds.getFilenameToDebugIdMap;
exports.escapeStringForRegex = escapeStringForRegex.escapeStringForRegex;
exports.supportsHistory = supportsHistory.supportsHistory;
exports._asyncNullishCoalesce = _asyncNullishCoalesce._asyncNullishCoalesce;
exports._asyncOptionalChain = _asyncOptionalChain._asyncOptionalChain;
exports._asyncOptionalChainDelete = _asyncOptionalChainDelete._asyncOptionalChainDelete;
exports._nullishCoalesce = _nullishCoalesce._nullishCoalesce;
exports._optionalChain = _optionalChain._optionalChain;
exports._optionalChainDelete = _optionalChainDelete._optionalChainDelete;
//# sourceMappingURL=index.js.map
