import { DeserializeFormDataOptions, SerializeFormDataOptions } from '../definitions/interfaces.js';
/**
 * Deserializes a `FormData` object into a plain object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/form-data)
 */
export declare function deserializeFormData<T extends object>(data: FormData, options?: DeserializeFormDataOptions): T;
/**
 * Serializes an object into a `FormData` object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/form-data)
 */
export declare function serializeFormData<T extends object>(object: T, options?: SerializeFormDataOptions): FormData;
