/**
 * Decodes a buffer into a string.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/text)
 */
export declare function decodeText(input: AllowSharedBufferSource, options?: TextDecodeOptions): string;
/**
 * Encodes a string into a Uint8Array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/text)
 */
export declare function encodeText(input: string): Uint8Array;
/**
 * Returns a new TextDecoder or a stub if the environment does not support it.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/text)
 */
export declare function getTextDecoder(): TextDecoder;
/**
 * Returns a new TextEncoder or a stub if the environment does not support it.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/text)
 */
export declare function getTextEncoder(): TextEncoder;
