import { DecodeJsonOptions, FetchDecodeOptions } from '../definitions/interfaces.js';
/**
 * The FetchResponse class is used for responses that are returned by the Fetch class.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/fetch-response)
 */
export declare class FetchResponse<T = unknown> implements Response {
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/body) */
    readonly body: ReadableStream<Uint8Array> | null;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/bodyUsed) */
    readonly bodyUsed: boolean;
    /**
     * The data that has been parsed.
     */
    data: T;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Response/headers) */
    readonly headers: Headers;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Response/ok) */
    readonly ok: boolean;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Response/redirected) */
    readonly redirected: boolean;
    protected readonly response: Response;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Response/status) */
    readonly status: number;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Response/statusText) */
    readonly statusText: string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Response/type) */
    readonly type: ResponseType;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Response/url) */
    readonly url: string;
    constructor(response: Response, data?: T);
    /**
     * Decodes the body in the most appropriate way inferring the type from the content-type header.
     * Optionally the type can be specified, it can be array-buffer, blob, form-data, json, text or url-search-params.
     */
    decode(options?: FetchDecodeOptions): Promise<void>;
    decodeArrayBuffer(): Promise<void>;
    decodeBlob(): Promise<void>;
    decodeFormData(): Promise<void>;
    decodeJSON(options?: DecodeJsonOptions): Promise<void>;
    decodeText(): Promise<void>;
    decodeURLSearchParams(): Promise<void>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/arrayBuffer) */
    arrayBuffer(): Promise<ArrayBuffer>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/blob) */
    blob(): Promise<Blob>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Response/clone) */
    clone(): Response;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/formData) */
    formData(): Promise<FormData>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/json) */
    json(): Promise<any>;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/text) */
    text(): Promise<string>;
    /**
     * Sets the data.
     */
    protected setData(data: any): void;
    /**
     * Creates a new FetchResponse instance.
     */
    static from<T>(data: T): FetchResponse<T>;
    static from<T>(response: Response): FetchResponse<T>;
    /**
     * Returns the content-type header.
     */
    protected get ContentType(): string;
}
