import type { QueueEvents, QueueOptions, QueueProcess } from '../definitions/interfaces.js';
import type { QueueFunction, QueueStatus } from '../definitions/types.js';
import { EventEmitter } from './event-emitter.js';
export declare class Queue extends EventEmitter<QueueEvents> {
    protected concurrency: number;
    protected delay: number;
    protected processes: QueueProcess[];
    protected status: QueueStatus;
    protected timeout: number;
    constructor(options?: QueueOptions);
    start(): this;
    stop(): this;
    clear(): this;
    protected run(): void;
    protected runp(process: QueueProcess): void;
    push(fns: QueueFunction[]): this;
    push(...fns: QueueFunction[]): this;
    unshift(fns: QueueFunction[]): this;
    unshift(...fns: QueueFunction[]): this;
    getConcurrency(): number;
    getDelay(): number;
    getProcesses(): QueueProcess[];
    getStatus(): QueueStatus;
    getTimeout(): number;
    setConcurrency(concurrency: number): this;
    setDelay(delay: number): this;
    setTimeout(timeout: number): this;
    get isStatusRunning(): boolean;
    get isStatusStopped(): boolean;
}
