import { ThrottleMapKey } from '../definitions/types.js';
/**
 * The `throttle` function is used to prevent a function from being called too many times in a short period.
 * The function will only be called if the time since the last call is greater than or equal to the specified amount of time.
 *
 * Optionally the key can be specified, otherwise the function itself will be used as the key.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/functions/throttle)
 */
export declare function throttle(fn: Function, ms: number, key?: ThrottleMapKey): void;
