/**
 * Checks if a value is an instance of a function.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/function)
 */
export declare function isInstanceOf<I extends Function>(value: any, instance: I): value is I;
/**
 * Checks if a value is not an instance of a function.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/function)
 */
export declare function isNotInstanceOf<T, I extends Function>(value: T, instance: I): value is T;
