import { GetLimitedNumberOptions, GetNumberPercentageOptions } from '../definitions/interfaces.js';
/**
 * Returns the absolute value of a number.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function getAbsoluteNumber(number: number): number;
/**
 * Returns the number with a fixed number of decimals.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function getFixedNumber(number: number, decimals: number): number;
/**
 * Returns the distance between two numbers.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function getNumbersDistance(a: number, b: number): number;
/**
 * Returns the number between a minimum and maximum value.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function getLimitedNumber(number: number, options?: GetLimitedNumberOptions): number;
/**
 * Returns the percentage of a number between a minimum and maximum value.
 * Optionally the percentage can be rounded.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function getNumberPercentage(number: number, options?: GetNumberPercentageOptions): number;
/**
 * Returns the highest number in an array of numbers.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function getHighestNumber(numbers: number[]): number;
export declare function getHighestNumber(...numbers: number[]): number;
/**
 * Returns the lowest number in an array of numbers.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function getLowestNumber(numbers: number[]): number;
export declare function getLowestNumber(...numbers: number[]): number;
/**
 * Parses an unknown value to a bigint.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function parseBigInt(value: unknown, fallback?: bigint): bigint;
/**
 * Parses an unknown value to a number.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function parseNumber(value: unknown, fallback?: number): number;
/**
 * Checks if the number is even.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function isNumberEven(number: number): boolean;
/**
 * Checks if the number is a multiple of another number.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function isNumberMultipleOf(number: number, of: number): boolean;
/**
 * Checks if the number is odd.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/number)
 */
export declare function isNumberOdd(number: number): boolean;
