import { AracnaFileJSON } from '../definitions/interfaces.js';
import { AracnaBlob } from './aracna-blob.js';
/**
 * The AracnaFile class extends the AracnaBlob class and is built on top of the File class.
 *
 * - The data contained in the File can be resolved asynchronously and accessed at a later time from the instance itself.
 * - The instance supports JSON serialization and deserialization out of the box unlike the File class.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/aracna-file)
 */
export declare class AracnaFile extends AracnaBlob {
    /**
     * The File instance.
     */
    readonly file: File;
    constructor(file: File);
    constructor(json: AracnaFileJSON);
    toJSON(): AracnaFileJSON;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/lastModified) */
    get lastModified(): number;
    /**
     * Returns the last modified date of the file.
     */
    get lastModifiedDate(): Date;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/name) */
    get name(): string;
    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/webkitRelativePath) */
    get webkitRelativePath(): string;
    /**
     * Returns an empty AracnaFile instance.
     */
    static get EMPTY(): AracnaFile;
}
