import { AracnaFile } from '../classes/aracna-file.js';
import { DeserializeFileOptions } from '../definitions/interfaces.js';
/**
 * Deserializes a `File` object into an `AracnaFile` instance.
 * Optionally resolves the data of the file.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/file)
 */
export declare function deserializeFile(file: File, options?: DeserializeFileOptions): Promise<AracnaFile>;
/**
 * Serializes an `AracnaFile` instance into a `File` object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/file)
 */
export declare function serializeFile(file: AracnaFile, endings?: EndingType): File;
