import { AppendSearchParamsToURLParams, DeserializeURLSearchParamsInit, SerializeURLSearchParamsInit, URLSearchParamsRecord } from '../definitions/types.js';
/**
 * Appends the search params to a URL.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/url)
 */
export declare function appendSearchParamsToURL<T extends URLSearchParamsRecord>(url: string, params: AppendSearchParamsToURLParams<T>, base?: string | URL): string;
export declare function appendSearchParamsToURL<T extends URLSearchParamsRecord>(url: URL, params: AppendSearchParamsToURLParams<T>, base?: string | URL): URL;
/**
 * Concatenates an URL with pathnames.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/url)
 */
export declare function concatURL(url: string, ...pathnames: Partial<string>[]): string;
export declare function concatURL(url: URL, ...pathnames: Partial<string>[]): URL;
/**
 * Deserializes an array, string, plain object or `URLSearchParams` to an array, string or plain object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/url)
 */
export declare function deserializeURLSearchParams<T extends URLSearchParamsRecord>(params: DeserializeURLSearchParamsInit): T;
export declare function deserializeURLSearchParams<T extends URLSearchParamsRecord>(params: DeserializeURLSearchParamsInit, type: 'string'): string;
export declare function deserializeURLSearchParams<T extends URLSearchParamsRecord>(params: DeserializeURLSearchParamsInit, type: 'array'): string[][];
export declare function deserializeURLSearchParams<T extends URLSearchParamsRecord>(params: DeserializeURLSearchParamsInit, type: 'object'): T;
/**
 * Removes the search params from an URL.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/url)
 */
export declare function removeSearchParamsFromURL(url: string): string;
export declare function removeSearchParamsFromURL(url: URL): URL;
/**
 * Serializes an array, string or plain object to `URLSearchParams`.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/url)
 */
export declare function serializeURLSearchParams<T extends object>(params: SerializeURLSearchParamsInit<T>): URLSearchParams;
/**
 * Checks if an unknown value is a URL.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/url)
 */
export declare function isURL(value: unknown, base?: string | URL): boolean;
/**
 * Checks if an unknown value is not a URL.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/url)
 */
export declare function isNotURL(value: unknown, base?: string | URL): boolean;
