import { Typeahead } from '../classes/typeahead.js';
import { TypeaheadOptions } from '../definitions/interfaces.js';
import { TypeaheadMapKey } from '../definitions/types.js';
/**
 * The `typeahead` function is used to search for items in a list, based on user input.
 * When a match is found, the `match` event is emitted.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/functions/typeahead)
 */
export declare function typeahead<T>(key: TypeaheadMapKey, chunks: string | string[], options?: TypeaheadOptions<T>): Typeahead<T>;
