import { DecodeBase32HexOptions, DecodeBase32Options, EncodeBase32HexOptions, EncodeBase32Options } from '../definitions/interfaces.js';
/**
 * Decodes a base32 string into a Uint8Array.
 *
 * [Araña Reference](https://arana.dariosechi.it/core/utils/base32)
 */
export declare function decodeBase32(string: string, options?: DecodeBase32Options): Uint8Array;
/**
 * Decodes a base32hex string into a Uint8Array.
 *
 * [Araña Reference](https://arana.dariosechi.it/core/utils/base32)
 */
export declare function decodeBase32Hex(string: string, options?: DecodeBase32HexOptions): Uint8Array;
/**
 * Encodes an array of integers into a base32 string.
 *
 * [Araña Reference](https://arana.dariosechi.it/core/utils/base32)
 */
export declare function encodeBase32(array: ArrayLike<number>, options?: EncodeBase32Options): string;
/**
 * Encodes an array of integers into a base32hex string.
 *
 * [Araña Reference](https://arana.dariosechi.it/core/utils/base32)
 */
export declare function encodeBase32Hex(array: ArrayLike<number>, options?: EncodeBase32HexOptions): string;
