import { BrowserOptions } from '@sentry/browser';
export interface Vue {
    config: {
        errorHandler?: any;
        warnHandler?: any;
        silent?: boolean;
    };
    mixin: (mixins: Partial<Record<Hook, any>>) => void;
}
export type ViewModel = {
    _isVue?: boolean;
    __isVue?: boolean;
    $root: ViewModel;
    $parent?: ViewModel;
    $props: {
        [key: string]: any;
    };
    $options?: {
        name?: string;
        propsData?: {
            [key: string]: any;
        };
        _componentTag?: string;
        __file?: string;
        __name?: string;
    };
};
export interface VueOptions {
    /** Vue constructor to be used inside the integration (as imported by `import Vue from 'vue'` in Vue2) */
    Vue?: Vue;
    /**
     * Vue app instance(s) to be used inside the integration (as generated by `createApp` in Vue3).
     */
    app?: Vue | Vue[];
    /**
     * When set to `false`, Sentry will suppress reporting of all props data
     * from your Vue components for privacy concerns.
     */
    attachProps: boolean;
    /**
     * When set to `true`, original Vue's `logError` will be called as well.
     * https://github.com/vuejs/vue/blob/c2b1cfe9ccd08835f2d99f6ce60f67b4de55187f/src/core/util/error.js#L38-L48
     *
     * @deprecated Will be removed in future versions of the SDK. The error will always be logged unless you define a custom Vue errorHandler.
     */
    logErrors: boolean;
    /**
     *  By default, Sentry attaches an error handler to capture exceptions and report them to Sentry.
     *  When `attachErrorHandler` is set to `false`, automatic error reporting is disabled.
     *
     *  Usually, this option should stay enabled, unless you want to set up Sentry error reporting yourself.
     *  For example, the Sentry Nuxt SDK does not attach an error handler as it's using the error hooks provided by Nuxt.
     *
     *  @default true
     */
    attachErrorHandler: boolean;
    /** {@link TracingOptions} */
    tracingOptions?: Partial<TracingOptions>;
    /**
     * Decides whether to track components by hooking into its lifecycle methods.
     * Can be either set to `boolean` to enable/disable tracking for all of them.
     * Or to an array of specific component names (case-sensitive).
     *
     * @deprecated Use tracingOptions
     */
    trackComponents: boolean | string[];
    /**
     * How long to wait until the tracked root activity is marked as finished and sent of to Sentry
     *
     * @deprecated Use tracingOptions
     */
    timeout: number;
    /**
     * List of hooks to keep track of during component lifecycle.
     * Available hooks: 'activate' | 'create' | 'destroy' | 'mount' | 'unmount' | 'update'
     * Based on https://vuejs.org/v2/api/#Options-Lifecycle-Hooks
     *
     * @deprecated Use tracingOptions
     */
    hooks: Operation[];
}
export interface Options extends BrowserOptions, VueOptions {
    /**
     * @deprecated Use `vueIntegration` tracingOptions
     */
    tracingOptions?: Partial<TracingOptions>;
    /**
     * Decides whether to track components by hooking into its lifecycle methods.
     * Can be either set to `boolean` to enable/disable tracking for all of them.
     * Or to an array of specific component names (case-sensitive).
     *
     * @deprecated Use `vueIntegration` tracingOptions
     */
    trackComponents: boolean | string[];
    /**
     * How long to wait until the tracked root activity is marked as finished and sent of to Sentry
     *
     * @deprecated Use `vueIntegration` tracingOptions
     */
    timeout: number;
    /**
     * List of hooks to keep track of during component lifecycle.
     * Available hooks: 'activate' | 'create' | 'destroy' | 'mount' | 'unmount' | 'update'
     * Based on https://vuejs.org/v2/api/#Options-Lifecycle-Hooks
     *
     * @deprecated Use `vueIntegration` tracingOptions
     */
    hooks: Operation[];
}
/** Vue specific configuration for Tracing Integration  */
export interface TracingOptions {
    /**
     * Decides whether to track components by hooking into its lifecycle methods.
     * Can be either set to `boolean` to enable/disable tracking for all of them.
     * Or to an array of specific component names (case-sensitive).
     */
    trackComponents: boolean | string[];
    /** How long to wait until the tracked root activity is marked as finished and sent of to Sentry */
    timeout: number;
    /**
     * List of hooks to keep track of during component lifecycle.
     * Available hooks: 'activate' | 'create' | 'destroy' | 'mount' | 'unmount' | 'update'
     * Based on https://vuejs.org/v2/api/#Options-Lifecycle-Hooks
     */
    hooks: Operation[];
}
export type Hook = 'activated' | 'beforeCreate' | 'beforeDestroy' | 'beforeUnmount' | 'beforeMount' | 'beforeUpdate' | 'created' | 'deactivated' | 'destroyed' | 'unmounted' | 'mounted' | 'updated';
export type Operation = 'activate' | 'create' | 'destroy' | 'mount' | 'update' | 'unmount';
//# sourceMappingURL=types.d.ts.map
