import { SetIntervalOptions } from '../definitions/interfaces.js';
import { IntervalMapKey } from '../definitions/types.js';
/**
 * Sets an interval to run a function every `ms` milliseconds.
 *
 * Optionally the key can be specified, otherwise the function itself will be used as the key.
 * Optionally runs the function immediately with the `autorun` option.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/interval)
 */
declare function set(fn: Function, ms: number, key?: IntervalMapKey, options?: SetIntervalOptions): void;
/**
 * Clears an interval.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/interval)
 */
declare function clear(key: IntervalMapKey): void;
/**
 * Clears all intervals.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/interval)
 */
export declare function clearEveryInterval(): void;
/**
 * Checks if an interval is set.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/interval)
 */
export declare function isIntervalSet(key: IntervalMapKey): boolean;
/**
 * Checks if an interval is not set.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/interval)
 */
export declare function isIntervalUnset(key: IntervalMapKey): boolean;
export { clear as clearInterval, set as setInterval };
