import { FcmRegistration, RegisterToFcmConfig, RegisterToFcmOptions } from '../definitions/interfaces.js';
/**
 * Registers a device to Firebase Cloud Messaging.
 *
 * - Optionally registers with already existing ACG ID and ACG security token.
 * - Optionally delays the ACG registration between each retry.
 * - Optionally uses a custom amount of retries for the ACG registration.
 *
 * Configuration:
 *
 * - The app ID is the package name of the app.
 * - The ECE auth secret and ECE public key must be generated beforehand with the `createFcmECDH` and `generateFcmAuthSecret` functions. The auth secret and ECDH keys must be stored.
 * - The Firebase API key, Firebase app ID and Firebase project ID can be found in the Firebase console.
 * - The VAPID key can be found in the Firebase console.
 *
 * Returns the ACG ID, ACG security token and FCM token, which must be stored.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/fcm/functions/register-to-fcm)
 */
export declare function registerToFCM(config: RegisterToFcmConfig, options?: RegisterToFcmOptions): Promise<FcmRegistration | Error>;
