import { GenerateRandomStringOptions } from '../definitions/interfaces.js';
/**
 * Returns a random string.
 *
 * - The alphabet is the set of characters that are used to generate the random string.
 * - The blacklist is a set of strings that are not allowed to be generated.
 * - The random function is a function that returns a random array of bytes.
 * - The prefix is the string that is prepended to the random string.
 * - The separator is the string that separates the prefix, the random string and the suffix.
 * - The size is the length of the random string.
 * - The suffix is the string that is appended to the random string.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function generateRandomString(options?: GenerateRandomStringOptions): string;
/**
 * Returns a string in camel case.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function getCamelCaseString(string: string): string;
/**
 * Returns a string with the first letter capitalized.
 * Optionally the rest of the letters can be set to lowercase.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function getCapitalizedString(string: string, lowercase?: boolean): string;
/**
 * Returns a string in kebab case.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function getKebabCaseString(string: string): string;
/**
 * Returns a string in pascal case.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function getPascalCaseString(string: string): string;
/**
 * Returns a string in snake case.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function getSnakeCaseString(string: string): string;
/**
 * Returns a string with a symbol between each word.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function getSymbolCaseString(string: string, symbol: string): string;
/**
 * Checks if a string is a float.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function isStringFloat(string: string): boolean;
/**
 * Checks if a string is an integer.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function isStringInt(string: string): boolean;
/**
 * Checks if a string is a JSON.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function isStringJSON(string: string): boolean;
/**
 * Checks if a string is not a JSON.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function isStringNotJSON(string: string): boolean;
/**
 * Checks if a string is a URL.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function isStringURL(string: string): boolean;
/**
 * Checks if a string is not a URL.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/string)
 */
export declare function isStringNotURL(string: string): boolean;
