import { AppearenceEvents, AppearenceInit } from '../definitions/interfaces.js';
import { Storage, Theme } from '../definitions/types.js';
import { EventEmitter } from './event-emitter.js';
/**
 * The Appearence class manages the theme of anything that can have an appearence.
 *
 * - The theme will persist to a storage of your choice, by default it will be stored in memory.
 * - The default theme is system, which means that the theme will be dark or light depending on the system theme.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/appearence)
 */
export declare class Appearence extends EventEmitter<AppearenceEvents> {
    /**
     * The storage that will be used to store the theme.
     */
    storage: Storage;
    /**
     * The key that will be used to store the theme.
     */
    storageKey: string;
    /**
     * The theme, can be dark, light or system.
     */
    theme: Theme;
    constructor(init?: AppearenceInit);
    /**
     * Retrieves the theme from the storage and sets it.
     */
    initialize(): Promise<boolean>;
    /**
     * Toggles the theme between dark and light.
     * If the theme is set to system, it will be set to dark or light depending on the system theme.
     */
    toggleTheme(): this;
    /**
     * Sets the theme.
     * The "change-theme" event will be emitted.
     */
    setTheme(theme: Theme): this;
    /**
     * Stores the theme in the storage.
     */
    store(): Promise<boolean>;
    /**
     * Registers the theme event listener in environments that support it.
     */
    protected registerThemeEventListener(): void;
    /**
     * Returns the theme depending on the system theme.
     */
    get themeByPrefersColorScheme(): Theme;
    /**
     * Checks if the theme is dark.
     */
    get isThemeDark(): boolean;
    /**
     * Checks if the theme is light.
     */
    get isThemeLight(): boolean;
    /**
     * Checks if the theme is system.
     */
    get isThemeSystem(): boolean;
}
