import { HistoryDataTarget } from '../definitions/interfaces.js';
export declare class History<T extends HistoryDataTarget = HistoryDataTarget, K extends keyof T = keyof T> {
    index: number;
    key: K;
    size: number;
    target: T;
    versions: T[K][];
    constructor(target: T, key: K, size?: number);
    redo(): void;
    undo(): void;
    push(): void;
    protected setIndex(offset: number): void;
    get isPushable(): boolean;
    get isNotPushable(): boolean;
    get isRedoable(): boolean;
    get isNotRedoable(): boolean;
    get isUndoable(): boolean;
    get isNotUndoable(): boolean;
}
