import { HasArrayItemPredicate, RemoveArrayItemsPredicate } from '../definitions/types.js';
/**
 * Creates a copy of an array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/array)
 */
export declare function cloneArray<T>(array: T[]): T[];
/**
 * Returns the symmetric difference between two or more arrays.
 * Optionally you can pass a custom function to check if an item is included in the result array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/array)
 */
export declare function getArraysDifference<T>(arrays: T[][], predicate?: HasArrayItemPredicate<T>): T[];
/**
 * Returns the intersection between two or more arrays.
 * Optionally you can pass a custom function to check if an item is included in the result array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/array)
 */
export declare function getArraysIntersection<T>(arrays: T[][], predicate?: HasArrayItemPredicate<T>): T[];
/**
 * Returns the last item of an array.
 * Optionally you can pass a fallback value that will be returned if the array is empty.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/array)
 */
export declare function getArrayLastItem<T>(array: T[]): T | undefined;
export declare function getArrayLastItem<T>(array: T[], fallback: T): T;
/**
 * Removes all duplicates from an array.
 * Optionally you can pass a custom function to check if an item is included in the result array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/array)
 */
export declare function removeArrayDuplicates<T>(array: T[], predicate?: HasArrayItemPredicate<T>): T[];
/**
 * Removes items from an array that match the predicate or are in the items array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/array)
 */
export declare function removeArrayItems<T>(array: T[], predicate: RemoveArrayItemsPredicate<T>): T[];
export declare function removeArrayItems<T>(array: T[], items: T[]): T[];
/**
 * Checks if the given value is an array.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/array)
 */
export declare function isArray<T>(value: any): value is T[];
