import { FetchRequestInit, NodeFetch, ToLoggableFetchRequestInitOptions, ToLoggableNativeFetchRequestInitOptions } from '../definitions/interfaces.js';
/**
 * Counts the number of headers in a `FetchRequestInit` or `RequestInit` object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function countFetchRequestInitHeaders<T>(init: FetchRequestInit<T> | RequestInit): number;
/**
 * Deletes a header from a `FetchRequestInit` or `RequestInit` object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function deleteFetchRequestInitHeader<T>(init: FetchRequestInit<T> | RequestInit, name: string): void;
/**
 * Returns a header from a `FetchRequestInit` or `RequestInit` object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function getFetchRequestInitHeader<T>(init: FetchRequestInit<T> | RequestInit, name: string): string | null;
/**
 * Returns the headers entries from a `FetchRequestInit` or `RequestInit` object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function getFetchRequestInitHeadersEntries<T>(init: FetchRequestInit<T> | RequestInit): string[][];
/**
 * Imports `node-fetch` only if the Fetch API is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function importNodeFetch(): Promise<NodeFetch | Error>;
/**
 * Merges two or more `FetchRequestInit` or `RequestInit` objects.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function mergeFetchRequestInits<T>(target: FetchRequestInit<T>, ...sources: FetchRequestInit<T>[]): FetchRequestInit<T>;
/**
 * Sets a header in a `FetchRequestInit` or `RequestInit` object.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function setFetchRequestInitHeader<T>(init: FetchRequestInit<T> | RequestInit, name: string, value: string): void;
/**
 * Sets a header a `FetchRequestInit` or `RequestInit` object if it is not set.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function setFetchRequestInitHeaderWhenUnset<T>(init: FetchRequestInit<T> | RequestInit, name: string, value: string): void;
/**
 * Polyfills the Fetch API with `node-fetch` if the Fetch API is not defined.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function useNodeFetch(NodeFetch: NodeFetch | Error): Promise<void>;
/**
 * Returns a version of a `FetchRequestInit` object that is easier to read in logs.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function toLoggableFetchRequestInit<T>(init: FetchRequestInit<T>, options?: ToLoggableFetchRequestInitOptions): FetchRequestInit;
/**
 * Returns a version of a `RequestInit` object that is easier to read in logs.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function toLoggableNativeFetchRequestInit(init: RequestInit, options?: ToLoggableNativeFetchRequestInitOptions): RequestInit;
/**
 * Converts a `FetchRequestInit` object to a `RequestInit` object.
 * Sets the `content-type` header based on the type of the body.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function toNativeFetchRequestInit<T>(init: FetchRequestInit<T>): RequestInit;
/**
 * Checks if a `FetchRequestInit` or `RequestInit` object has a header.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/utils/fetch)
 */
export declare function hasFetchRequestInitHeader<T>(init: FetchRequestInit<T> | RequestInit, name: string): boolean;
