import { TypeaheadEvents } from '../definitions/interfaces.js';
import { TypeaheadMapKey, TypeaheadPredicate } from '../definitions/types.js';
import { EventEmitter } from './event-emitter.js';
/**
 * The Typeahead class is a state and options holder for the typeahead function.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/typeahead)
 */
export declare class Typeahead<T> extends EventEmitter<TypeaheadEvents<T>> {
    /**
     * The chunks that make up the query string.
     */
    protected chunks: string[];
    /**
     * The debounce time.
     */
    protected debounceTime: number;
    /**
     * The items to search.
     */
    protected items: T[];
    /**
     * The key of the instance.
     */
    protected readonly key: TypeaheadMapKey;
    /**
     * The predicate function.
     */
    protected predicate: TypeaheadPredicate<T>;
    constructor(key: TypeaheadMapKey, items?: T[], predicate?: TypeaheadPredicate<T>, debounceTime?: number);
    /**
     * The debounce function.
     */
    protected debouncefn: () => void;
    /**
     * Searches the items for a match and emits the match event if a match is found.
     */
    search(): this;
    /**
     * Returns the debounce time.
     */
    getDebounceTime(): number;
    /**
     * Returns the items.
     */
    getItems(): T[];
    /**
     * Returns the key of the instance.
     */
    getKey(): TypeaheadMapKey;
    /**
     * Returns the predicate function.
     */
    getPredicate(): TypeaheadPredicate<T>;
    /**
     * Returns the query string.
     */
    getQuery(): string;
    /**
     * Pushes chunks to the chunks array.
     */
    pushChunks(...chunks: string[]): this;
    /**
     * Sets the debounce time.
     */
    setDebounceTime(debounceTime: number | undefined): this;
    /**
     * Sets the items.
     */
    setItems(items: T[] | undefined): this;
    /**
     * Sets the chunks.
     */
    setChunks(chunks: string[] | undefined): this;
    /**
     * Sets the predicate function.
     */
    setPredicate(predicate: TypeaheadPredicate<T> | undefined): this;
}
