import { EventEmitterListener, EventEmitterListenerOptions } from '../definitions/interfaces.js';
import { EventEmitterEvents } from '../definitions/types.js';
/**
 * The EventEmitter class is used to emit events and register listeners.
 * The API is based on the Node.js EventEmitter API.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/event-emitter)
 */
export declare class EventEmitter<T extends EventEmitterEvents = EventEmitterEvents> {
    protected listeners: EventEmitterListener<T, keyof T>[];
    protected maxListeners: number;
    constructor();
    /**
     * Counts the listeners that match the name, callback and options.
     * If no arguments are passed, all listeners will be counted.
     */
    countListeners<K extends keyof T>(name?: K, callback?: T[K], options?: EventEmitterListenerOptions): number;
    /**
     * Emits an event.
     */
    emit<K extends keyof T>(name: K, ...args: Parameters<T[K]>): boolean;
    /**
     * Returns the names of the events that have listeners.
     */
    getEventNames(): (keyof T)[];
    /**
     * Returns the listeners that match the name, callback and options.
     * If no arguments are passed, all listeners will be returned.
     */
    getListeners<K extends keyof T>(name?: K, callback?: T[K], options?: EventEmitterListenerOptions): EventEmitterListener<T, keyof T>[];
    /**
     * Returns the maximum number of listeners that can be registered for a single event.
     */
    getMaxListeners(): number;
    /**
     * Checks if the event has listeners that match the name, callback and options.
     */
    hasListeners<K extends keyof T>(name?: K, callback?: T[K], options?: EventEmitterListenerOptions): boolean;
    /**
     * Removes the listeners that match the name, callback and options.
     * If no arguments are passed, all listeners will be removed.
     */
    off<K extends keyof T>(name?: K, callback?: T[K], options?: EventEmitterListenerOptions): this;
    /**
     * Adds a listener, which will be called when the event is emitted.
     *
     * Optionally the listener can be removed after the first call with the `once` option.
     * Optionally the listener can be prepended to the listeners array with the `prepend` option.
     */
    on<K extends keyof T>(name: K, callback: T[K], options?: EventEmitterListenerOptions): this;
    /**
     * Adds a listener, which will be called only once when the event is emitted.
     */
    once<K extends keyof T>(name: K, callback: T[K], options?: EventEmitterListenerOptions): this;
    /**
     * Adds a listener, which will be called first when the event is emitted.
     */
    prepend<K extends keyof T>(name: K, callback: T[K], options?: EventEmitterListenerOptions): this;
    /**
     * Sets the listeners.
     */
    setListeners(listeners: EventEmitterListener<T, keyof T>[]): this;
    /**
     * Sets the maximum number of listeners that can be registered for a single event.
     */
    setMaxListeners(n: number): this;
}
