import { StatusTransformer } from '../definitions/types.js';
/**
 * The Status class manages the status of anything that can have a 4-state status: idle, pending, success, error.
 *
 * [Aracna Reference](https://aracna.dariosechi.it/core/classes/status)
 */
export declare class Status {
    /**
     * The Map that stores the status of each key.
     */
    readonly data: Map<string, string>;
    /**
     * The function that transforms the keys before storing them in the Map.
     */
    readonly transformer: StatusTransformer;
    constructor(transformer?: StatusTransformer);
    /**
     * Retrieves the status of the given keys.
     */
    get(...keys: string[]): string;
    /**
     * Sets the status of the given keys to idle.
     */
    idle(...keys: string[]): void;
    /**
     * Sets the status of the given keys to pending.
     */
    pending(...keys: string[]): void;
    /**
     * Sets the status of the given keys to success.
     */
    success(...keys: string[]): void;
    /**
     * Sets the status of the given keys to error.
     */
    error(...keys: string[]): void;
    /**
     * Sets the status of the given keys to the given status.
     */
    set(keys: string[], status: string): void;
    /**
     * Clears the status of every key.
     */
    clear(): void;
    /**
     * Checks if the status of the given keys is idle.
     */
    isIdle(...keys: string[]): boolean;
    /**
     * Checks if the status of the given keys is pending.
     */
    isPending(...keys: string[]): boolean;
    /**
     * Checks if the status of the given keys is success.
     */
    isSuccess(...keys: string[]): boolean;
    /**
     * Checks if the status of the given keys is error.
     */
    isError(...keys: string[]): boolean;
    /**
     * Checks if the status of every given key is idle.
     */
    isEveryIdle(...keys: string[][]): boolean;
    /**
     * Checks if the status of every given key is pending.
     */
    isEveryPending(...keys: string[][]): boolean;
    /**
     * Checks if the status of every given key is success.
     */
    isEverySuccess(...keys: string[][]): boolean;
    /**
     * Checks if the status of every given key is error.
     */
    isEveryError(...keys: string[][]): boolean;
    /**
     * Checks if the status of some given key is idle.
     */
    areSomeIdle(...keys: string[][]): boolean;
    /**
     * Checks if the status of some given key is pending.
     */
    areSomePending(...keys: string[][]): boolean;
    /**
     * Checks if the status of some given key is success.
     */
    areSomeSuccess(...keys: string[][]): boolean;
    /**
     * Checks if the status of some given key is error.
     */
    areSomeError(...keys: string[][]): boolean;
    static get IDLE(): string;
    static get PENDING(): string;
    static get SUCCESS(): string;
    static get ERROR(): string;
}
