import { ConfigurationFunctions } from './interfaces.js';
import { DebounceMapKey, DebounceMapValue, DeleteObjectPropertiesPredicate, GenerateRandomStringRandom, HasArrayItemPredicate, IntervalMapKey, IntervalMapValue, LoggerLevel, LoggerStatus, RemoveArrayItemsPredicate, StatusTransformer, Theme, ThrottleMapKey, TimeoutMapKey, TimeoutMapValue, TypeaheadMapKey, TypeaheadMapValue } from './types.js';
/**
 * Any
 */
/** */
export declare const EMPTY_OBJECT: () => Record<PropertyKey, any>;
/**
 * Appearence
 */
/** */
export declare const DEFAULT_APPEARENCE_STORAGE_KEY: string;
export declare const DEFAULT_APPEARENCE_THEME: Theme;
/**
 * Array Utils
 */
/** */
export declare const DEFAULT_HAS_ARRAY_ITEM_PREDICATE: HasArrayItemPredicate<any>;
export declare const DEFAULT_REMOVE_ARRAY_ITEMS_PREDICATE: RemoveArrayItemsPredicate<any>;
/**
 * Configuration
 */
/** */
export declare const DEFAULT_FUNCTIONS_CONFIGURATION: () => ConfigurationFunctions;
/**
 * Cookie
 */
/** */
export declare const DEFAULT_COOKIE_SEPARATOR: string;
/**
 * Debounce
 */
/** */
export declare const DEBOUNCE_MAP: Map<DebounceMapKey, DebounceMapValue>;
/**
 * EventEmitter
 */
/** */
export declare const DEFAULT_EVENT_EMITTER_MAX_LISTENERS: number;
/**
 * History
 */
/** */
export declare const DEFAULT_HISTORY_SIZE: number;
/**
 * Interval
 */
/** */
export declare const INTERVAL_MAP: Map<IntervalMapKey, IntervalMapValue>;
/**
 * Localization
 */
/** */
export declare const DEFAULT_LOCALIZATION_STORAGE_KEY: string;
export declare const REGEXP_VARIABLE_INSIDE_CURLY_BRACKETS: RegExp;
export declare const SORT_REGEXP_VARIABLE_INSIDE_CURLY_BRACKETS_MATCHES_COMPARE_FN: (a: string, b: string) => number;
/**
 * Logger
 */
/** */
export declare const DEFAULT_LOGGER_SEPARATOR: string;
export declare const LOGGER_LEVELS: LoggerLevel[];
export declare const LOGGER_STATUSES: LoggerStatus[];
/**
 * MemoryStorage
 */
/** */
export declare const MEMORY_STORAGE_MAP: Map<PropertyKey, any>;
/**
 * Number Utils
 */
/** */
export declare const REGEXP_FLOAT: RegExp;
export declare const REGEXP_INT: RegExp;
export declare const DEFAULT_GET_NUMBER_PERCENTAGE_MAX: number;
export declare const DEFAULT_GET_NUMBER_PERCENTAGE_MIN: number;
/**
 * Object Utils
 */
/** */
export declare const DEFAULT_DELETE_OBJECT_PROPERTIES_PREDICATE: DeleteObjectPropertiesPredicate<any, any>;
export declare const DEFAULT_OMIT_OBJECT_PROPERTIES_PREDICATE: DeleteObjectPropertiesPredicate<any, any>;
export declare const DEFAULT_PICK_OBJECT_PROPERTIES_PREDICATE: DeleteObjectPropertiesPredicate<any, any>;
export declare const REGEXP_LEFT_SQUARE_BRACKET_WITHOUT_LEADING_DOT: RegExp;
export declare const REGEXP_SQUARE_BRACKETS: RegExp;
/**
 * Path Utils
 */
/** */
export declare const CHAR_BACKWARD_SLASH = 92;
export declare const CHAR_COLON = 58;
export declare const CHAR_DOT = 46;
export declare const CHAR_FORWARD_SLASH = 47;
export declare const CHAR_LOWERCASE_A = 97;
export declare const CHAR_LOWERCASE_Z = 122;
export declare const CHAR_UPPERCASE_A = 65;
export declare const CHAR_UPPERCASE_Z = 90;
/**
 * Queue
 */
/** */
export declare const DEFAULT_QUEUE_CONCURRENCY: number;
export declare const DEFAULT_QUEUE_DELAY: number;
export declare const DEFAULT_QUEUE_TIMEOUT: number;
/**
 * Status
 */
/** */
export declare const DEFAULT_STATUS_TRANSFORMER: StatusTransformer;
/**
 * String Utils
 */
/** */
export declare const ALPHABET_LOWERCASE: string;
export declare const ALPHABET_NO_LOOK_ALIKES_SAFE: string;
export declare const ALPHABET_NO_LOOK_ALIKES: string;
export declare const ALPHABET_NUMBERS: string;
export declare const ALPHABET_UPPERCASE: string;
export declare const ALPHABET_ALPHANUMERIC: string;
export declare const ALPHABET_HEX_LOWERCASE: string;
export declare const ALPHABET_HEX_UPPERCASE: string;
export declare const DEFAULT_GENERATE_RANDOM_STRING_ALPHABET: string;
export declare const DEFAULT_GENERATE_RANDOM_STRING_RANDOM: GenerateRandomStringRandom;
export declare const DEFAULT_GENERATE_RANDOM_STRING_SEPARATOR: string;
export declare const DEFAULT_GENERATE_RANDOM_STRING_SIZE: number;
export declare const REGEXP_NOT_LETTERS_AND_NUMBERS: RegExp;
export declare const REGEXP_NOT_LOWERCASE_LETTERS_AND_NUMBERS: RegExp;
export declare const REGEXP_UPPERCASE_LETTERS: RegExp;
/**
 * Throttle
 */
/** */
export declare const THROTTLE_MAP: Map<ThrottleMapKey, number>;
/**
 * Timeout
 */
/** */
export declare const TIMEOUT_MAP: Map<TimeoutMapKey, TimeoutMapValue>;
/**
 * Typeahead
 */
/** */
export declare const DEFAULT_TYPEAHEAD_DEBOUNCE_TIME: number;
export declare const TYPEAHEAD_MAP: Map<TypeaheadMapKey, TypeaheadMapValue>;
/**
 * wf & wfp
 */
/** */
export declare const DEFAULT_WF_MS: number;
export declare const DEFAULT_WF_TIMEOUT: number;
export declare const DEFAULT_WFP_MS: number;
export declare const DEFAULT_WFP_TIMEOUT: number;
